TITLE   'Field around a Permanent Magnet' 		         { exa125.pde }
SELECT     						{ Student Edition }
   errlim=3e-4     ngrid=1     spectral_colors	
VARIABLES   Az
DEFINITIONS                      				
   L=1.0   L0=0.05
   mu0=4*pi*1e-7   mu=mu0   Jz=0   B0=0.1	{ Magnetic induction }	
   Bex=dy(Az)   Bey=-dx(Az)
   B=vector( Bex, Bey)   Bm=magnitude( B)
   Hx=Bex/mu   Hy=Bey/mu   H=B/mu   Hm=Bm/mu	
EQUATIONS
   dx( Hy)- dy( Hx)=Jz
BOUNDARIES
region 'domain'      	
   start 'outer' (-L,-L) value(Az)=0 line to (L,-L) to (L,L) to (-L,L) close
   start 'magnet' (-L0,-2*L0) value(Az)=-B0*x   	{ Exclude }
   line to (L0,-2*L0) to (L0,2*L0) to (-L0,2*L0) close
PLOTS
   elevation( Az) on 'magnet'			{ Verify Az on inner boundary }
   elevation( -normal( B)) on 'magnet'
   contour( Bm) log   vector( B) norm
   contour( Bm) painted zoom(-5*L0,-5*L0,  10*L0,10*L0)
   vector( B) norm zoom(-5*L0,-5*L0,  10*L0,10*L0)
END

